/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.loader.fabric;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigComment;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.ConfigParams;
import com.corosus.modconfig.CoroConfigRegistry;
import com.corosus.modconfig.IConfigCategory;
import com.corosus.modconfig.ModConfigData;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfigDataFabric
extends ModConfigData {
    public HashMap<String, ForgeConfigSpec.ConfigValue<String>> valsStringConfig = new HashMap();
    public HashMap<String, ForgeConfigSpec.ConfigValue<Integer>> valsIntegerConfig = new HashMap();
    public HashMap<String, ForgeConfigSpec.ConfigValue<Double>> valsDoubleConfig = new HashMap();
    public HashMap<String, ForgeConfigSpec.ConfigValue<Boolean>> valsBooleanConfig = new HashMap();

    public ModConfigDataFabric(String savePath, String parStr, Class parClass, IConfigCategory parConfig) {
        super(savePath, parStr, parClass, parConfig);
    }

    @Override
    public String getConfigString(String fieldName) {
        return (String)this.valsStringConfig.get(fieldName).get();
    }

    @Override
    public Integer getConfigInteger(String fieldName) {
        return (Integer)this.valsIntegerConfig.get(fieldName).get();
    }

    @Override
    public Double getConfigDouble(String fieldName) {
        return (Double)this.valsDoubleConfig.get(fieldName).get();
    }

    @Override
    public Boolean getConfigBoolean(String fieldName) {
        return (Boolean)this.valsBooleanConfig.get(fieldName).get();
    }

    @Override
    public <T> void setConfig(String fieldName, T obj) {
        if (obj instanceof String) {
            this.valsStringConfig.get(fieldName).set((Object)((String)obj));
            this.valsStringConfig.get(fieldName).save();
        } else if (obj instanceof Integer) {
            this.valsIntegerConfig.get(fieldName).set((Object)((Integer)obj));
            this.valsIntegerConfig.get(fieldName).save();
        } else if (obj instanceof Double) {
            this.valsDoubleConfig.get(fieldName).set((Object)((Double)obj));
            this.valsDoubleConfig.get(fieldName).save();
        } else if (obj instanceof Boolean) {
            this.valsBooleanConfig.get(fieldName).set((Object)((Boolean)obj));
            this.valsBooleanConfig.get(fieldName).save();
        }
    }

    @Override
    public void writeConfigFile(boolean resetConfig) {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.comment("General mod settings").push("general");
        Field[] fields = this.configClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            this.addToConfig(BUILDER, field, name);
        }
        CULog.dbg("writeConfigFile invoked for " + this.configID + ", resetConfig: " + resetConfig);
        BUILDER.pop();
        ForgeConfigSpec CONFIG = BUILDER.build();
        ConfigMod.instance();
        ForgeConfigRegistry.INSTANCE.register("coroutil", ModConfig.Type.COMMON, (IConfigSpec)CONFIG, this.saveFilePath + ".toml");
    }

    private void addToConfig(ForgeConfigSpec.Builder builder, Field field, String name) {
        Object obj;
        ConfigParams anno_params;
        String comment = "-";
        double min = Double.MIN_VALUE;
        double max = Double.MAX_VALUE;
        ConfigComment anno_comment = field.getAnnotation(ConfigComment.class);
        if (anno_comment != null) {
            comment = anno_comment.value()[0];
        }
        if ((anno_params = field.getAnnotation(ConfigParams.class)) != null) {
            comment = anno_params.comment();
            min = anno_params.min();
            max = anno_params.max();
        }
        if ((obj = CoroConfigRegistry.instance().getField(this.configID, name)) instanceof String) {
            this.valsStringConfig.put(name, (ForgeConfigSpec.ConfigValue<String>)builder.comment(comment).define(name, (Object)((String)obj)));
        } else if (obj instanceof Integer) {
            this.valsIntegerConfig.put(name, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment(comment).defineInRange(name, ((Integer)obj).intValue(), (int)min, (int)max));
        } else if (obj instanceof Double) {
            this.valsDoubleConfig.put(name, (ForgeConfigSpec.ConfigValue<Double>)builder.comment(comment).defineInRange(name, ((Double)obj).doubleValue(), min, max));
        } else if (obj instanceof Boolean) {
            this.valsBooleanConfig.put(name, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment(comment).define(name, (Object)((Boolean)obj)));
        }
        this.setFieldBasedOnType(name, obj);
    }
}

